#!/bin/sh

# Run test scripts

fails=0
passes=0

if [ "$1" = "gold" ]; then
    printf "Generating gold results files\n"
fi
for t in *.vc; do
    testname=${t%%.vc}
    result=${testname}.result
    gold=${testname}.gold
    echo "== ${testname}"
    ../vc ${t} >${result} 2>&1
    if [ "$1" = "gold" ]; then
        cp ${result} ${gold}
        rm ${result}
    else
        if [ ! -r ${gold} ]; then
            printf "   No gold test results file\n"
            continue
        fi
        diff ${result} ${gold}
        if [ $? != "0" ]; then
            fails=$((${fails}+1))
        else
            passes=$((${passes}+1))
            rm ${result}
        fi
    fi
done

# test summary
if [ "$1" != "gold" ]; then
    printf "\nPasses: %d\tFails: %d\n" ${passes} ${fails}
fi
