/*
 * $Id: stack.c,v 1.2 2004/10/30 13:38:23 mark Exp $
 *
 * NAME
 *     stack.c - contains stack routines for maf
 *
 * SYNOPSIS
 *     void strpush(char *s);
 *         Pushes string onto stack - overflow causes exit
 *     char *strpull();
 *         Returns top value and pops string stack - underflow causes exit
 *     int strdepth(void);
 *         Returns current depth of stack - zero = empty
 *     void strstkprint(void);
 *         Prints stack contents, omitting alternate entries
 *     void ipush(int i);
 *         Pushes integer onto stack - overflow causes exit
 *     int ipull(void);
 *         Returns top value and pops integer stack - underflow causes exit
 *
 * DESCRIPTION
 *     Set of stack routines to support the Multi-word Anagram Finder.
 *
 * NOTES
 *     Integer stack routines unused.
 *
 * MODIFICATION HISTORY
 * Mnemonic    Date    Rel Who
 * STK         01Oct05 1.0 MPW
 *     Written
 *
 * Copyright (C) 2001, 2004 Mark Willson.
 *  
 * This file is part of the maf program.
 *
 * The maf program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * The maf program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "stack.h"

// Routines to manage string stack

#define STKMAX 20
#define STRLEN 80

char strstk [STKMAX] [STRLEN];
int strstktop = 0;

void strpush(char *s)
{
    if (strstktop >= STKMAX) {
        fprintf(stderr,"strpush: stack overflow at %s\n",s);
        exit(-1);
    }
    strcpy(strstk[strstktop++],s);
    return;
}   

char *strpull(void)
{
    if (strstktop <= 0) {
        fprintf(stderr,"strpull: stack underflow\n");
        exit(-1);
    }
    return(strstk[--strstktop]);
}

int strdepth(void)
{
    return(strstktop);
}

void strstkprint(void) 
{
    int i;

    // omit sentinals, so start at index of 2
    for (i=2 ; i<strstktop ; i+=2) {
        printf("%s ",strstk[i]);
    }
    printf("\n");
}   

// Integer stack routines

int istk[STKMAX];
int istktop = 0;

void ipush(int i)
{
    if (istktop >= STKMAX) {
        fprintf(stderr,"ipush: stack overflow at %d\n",i);
        exit(-1);
    }
    istk[istktop++] = i;
    return;
}   

int ipull(void)
{
    if (istktop <= 0) {
        fprintf(stderr,"ipull: stack underflow\n");
        exit(-1);
    }
    return(istk[--istktop]);
}   

