/*
**		    Copyright (c) 1985	Ken Wellsch
**
**     Permission is hereby granted to all users to possess, use, copy,
**     distribute, and modify the programs and files in this package
**     provided it is not for direct commercial benefit and secondly,
**     that this notice and all modification information be kept and
**     maintained in the package.
**
*/
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#include <stdlib.h>

#include "mdefs.h"

#define MAXPB		60

struct files
{
	char *fnam ;
	int cnt ;
	FILE *fd ;
} ;

static struct files fx[15] =
{
	{ "(stdin)", 0, NULL },
	{ "(stdout)", 0, NULL },
	{ "(stderr)", 0, NULL },
	{ "", 0, NULL },
	{ "", 0, NULL },
	{ "", 0, NULL },
	{ "", 0, NULL },
	{ "", 0, NULL },
	{ "", 0, NULL },
	{ "", 0, NULL },
	{ "", 0, NULL },
	{ "", 0, NULL },
	{ "", 0, NULL },
	{ "", 0, NULL },
	{ "", 0, NULL }
} ;

static char pbuf[MAXPB] ;
static short int pbp = 0 ;

static char inbuf[MAXLINE] ;
static short int ibp = MAXLINE ;

/* stdin, stdout and stderr are not necessarily static and therefore
 * cannot be used in the intialisation of the fx array.  munge main
 * calls fx_init(). */
void fx_init(void)
{
    fx[0].fd = stdin;
    fx[1].fd = stdout;
    fx[2].fd = stderr;
    return;
}

int openf (name)

  char *name ;

{
	FILE *fd ;
	register int unit ;
	register char *s ;
	char *strsav(), *rindex() ;

	if ( ( fd = fopen (name,"r") ) == NULL )
		return (-1) ;
	unit = fileno (fd) ;
	if ( ( s = rindex (name,'/') ) == (char *)0 )
		fx[unit].fnam = strsav (name) ;
	else
		fx[unit].fnam = strsav (&(s[1])) ;
	fx[unit].cnt = 0 ;
	fx[unit].fd = fd ;
	return (unit) ;
}

void closef (unit)
  int unit ;
{
	if ( fx[unit].fd != NULL )
	{
		fx[unit].cnt = 0 ;
		fclose (fx[unit].fd) ;
		fx[unit].fd = NULL ;
	}
	return ;
}

int Getc ()
{
	register int c ;
	static int Eof = 0 ;

	if ( pbp > 0 )
	{
		c = pbuf[pbp--] ;
	}
	else
	{
		if ( ibp >= MAXLINE || inbuf[ibp] == EOS )
		{
			if ( Eof )
				return EOF ;
			for (;;)
			{
				if ( fgets (inbuf,MAXLINE,fx[inunit].fd) != NULL )
					break ;
				closef (inunit) ;
				if ( ( inunit = pop () ) == ERROR )
				{
					ibp = MAXLINE ;
					Eof = 1 ;
					return EOF ;
				}
                else
                {
                    printf(" Done.\n");
                }
			}
			ibp = 0 ;
			fx[inunit].cnt++ ;
			if (list)
				prlist (inbuf) ;
		}
		c = inbuf[ibp++] ;
	}

	return (c) ;
}

void Ungetc (c)
  int c ;
{
	if ( ++pbp >= MAXPB )
		error ("Ungetc","too many characters (%d) put back!",MAXPB) ;
	pbuf[pbp] = c ;
	return ;
}

void pbstr (s)
  char s[] ;
{
	register int i ;

	for ( i = strlen(s)-1 ; i >= 0 ; i-- )
		Ungetc (s[i]) ;
	return ;
}

void prlist (line)
  char *line ;
{
	printf ("%4d %-8s %s",fx[inunit].cnt,fx[inunit].fnam,line) ;
	return ;
}

/*VARARGS1*/
void error (char* rnam, char* fmt, ...)
{
    va_list ap;

	if ( inunit >= 0 )
		fprintf (stderr,"%s(%d)[%s]: ",fx[inunit].fnam,
			fx[inunit].cnt,rnam) ;
	else
		fprintf (stderr,"(EOF) %s: ",rnam) ;
    va_start (ap,fmt);
	vfprintf (stderr,fmt,ap);
    va_end (ap);
	fprintf (stderr,"\n") ;
	exit (1) ;
}

/*VARARGS1*/
void errout (char* fmt, ...)
{
    va_list ap;

    va_start (ap,fmt);
    vfprintf (stderr,fmt,ap);
    va_end (ap);
    return ;
}

/*VARARGS1*/
void synerr (char* rnam,char * fmt, ...)
{
    va_list ap;
    
	if ( inunit >= 0 )
		fprintf (stderr,"%s(%d): ",fx[inunit].fnam,fx[inunit].cnt) ;
	else
		fprintf (stderr,"(EOF) %s: ",rnam) ;
    va_start (ap,fmt);
	vfprintf (stderr,fmt,ap);
    va_end (ap);
	fprintf (stderr,"\n") ;
	flushline () ;
	return ;
}
